#!/bin/bash
set -e

FASTBOOT=fastboot
ADB=adb

echo "Librebooter OS experimental factory image"
echo "Device: Pixel 3a XL (bonito)"
echo "No vendor, radio, or bootloader images included"
echo "Requires unlocked bootloader and existing firmware"
echo

# If device is booted and adb works, use it
if command -v $ADB >/dev/null 2>&1 && $ADB get-state 1>/dev/null 2>&1; then
    echo "ADB detected, rebooting to bootloader..."
    $ADB reboot bootloader
    sleep 5
else
    echo "ADB not available or device not booted."
    echo "Assuming device is already in bootloader mode."
fi

# Verify fastboot works
if ! command -v $FASTBOOT >/dev/null 2>&1; then
    echo "ERROR: fastboot not found in PATH"
    exit 1
fi

if ! $FASTBOOT devices | grep -q .; then
    echo "ERROR: No fastboot device detected"
    exit 1
fi


# You have to flash boot in bootloader mode. Wait before booting into fastbootd.
echo "Flashing boot..."
$FASTBOOT flash boot boot.img
echo "Booting to fastbootd (fastboot for dynamic partitions), please wait..."
$FASTBOOT reboot fastboot
sleep 5

if ! $FASTBOOT devices | grep -q fastboot; then
    echo "ERROR: Device did not enter fastbootd"
    exit 1
fi

echo "Flashing system partitions..."
$FASTBOOT flash system system.img
$FASTBOOT flash system_ext system_ext.img
$FASTBOOT flash product product.img

echo
echo "Flash complete."
echo "Rebooting device..."

$FASTBOOT reboot
